function h = loadDistribution( obj )
%LOADDISTRIBUTION Display the load distribution for adjacency matrix Obj
%   h = LOADDISTRIBUTION(OBJ) will plot the load distribution for an
%       adjacency matrix object, returning a handle to the data set.  Load
%       distribution is defined to be the histogram of connection weights
%       accross the entire Adjacency Matrix.  This will create two plots.
%       One gives the survival function for the load distribution (not
%       including zero values), and the other is the histogram of values
%       (not including zero values)


% First plot the survival function
data = obj.A(obj.A>0);

% q is unique values in data, sorted
n = length(data);
q = unique(data);
c = hist(data,q)'./n;
c = [[q; q(end)+1] 1-[0; cumsum(c)]]; c(c(:,2)<10^-10,:) = [];
% c(:,2) = c(:,2)*n;
figure;
h = semilogy(c(:,1),c(:,2),'bo','MarkerSize',8,'MarkerFaceColor',[1 1 1]);
hold on
title('Survival Function of connection weight distribution');
xlabel(gca,'Weight of connection');
ylabel(gca,'Log number of connections > weight of connection');
set(gcf,'Color',[1 1 1]);
hold off;

% Now plot the histogram
figure;
binWidth = 1;
nBins = full(ceil(max(data)/binWidth));
hist(full(data),linspace(binWidth/2,nBins*binWidth - binWidth/2,nBins));
hold on;
title('Histogram of connection weights');
xlabel(gca,'Weight of connection');
ylabel(gca,'Number of connections');
set(gcf,'Color',[1 1 1]);
hold off;

% Now plot the load distribution (number of connections) * (connection
% weight)
figure;
binWidth = 1;
nBins = full(ceil(max(data)/binWidth));
[N,X] = hist(full(data),linspace(binWidth/2,nBins*binWidth - binWidth/2,nBins));
bar(X,[1:numel(X)].*N);
hold on;
title('Load distribution');
xlabel(gca,'Weight of connection');
ylabel(gca,'Number of connections * weight of connection');
set(gcf,'Color',[1 1 1]);
hold off;

% Now plot the cumulative load distribution (number of connections) *
% (connection weight) < connection weight
figure;
n = length(data);
q = unique(data);
c = hist(data,q)';
c = c.*q;
c = c./sum(c);
plot(q, cumsum(c));
cumsum(c)
axis([0 max(data) 0 1]);
title('Cumulative load distribution');
xlabel(gca,'x = Weight of connection');
ylabel(gca,'total load carried by connections with weight {\leq} x');
set(gcf,'Color',[1 1 1]);


% [lambda,xmin,L] = expFit(data);
% h = expPlot(data,xmin,lambda);
% title('Survival Function of Load Distribution, Exponential Fit');
% xlabel(gca,'Weight of connection');
% ylabel(gca,'Log number of connections > weight of connection');
% set(gcf,'Color',[1 1 1]);
% 
% 
% [alpha,xmin,L] = plfit(data,'finite');
% h = plplot(data,xmin,alpha);
% title('Survival Function of Load Distribution, Power-law Fit');
% xlabel(gca,'Log weight of connection');
% ylabel(gca,'Log number of connections > weight of connection');
% set(gcf,'Color',[1 1 1]);


end

